package doABC;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import FlashReader.*;

public class ScriptInfo extends SwfTools {
	
	private int id;
	public static int script_count;
	private AbcFile abc;
	private DoABC doabc;
	private int start;
	private int end;
	
	//struktury
	private int init;
	private int trait_count;
	private ArrayList<TraitInfo> tinfo = new ArrayList<TraitInfo>();//optional


	public ScriptInfo(DoABC doabc, int init, int trait_count, ArrayList<TraitInfo> tinfo){
		super();
		script_count++;
		this.doabc = doabc;
		this.abc = doabc.getAbcData();
		abc.ENscript_info.add(this);
		id= abc.ENscript_info.size()-1;
		this.init = init;
		this.trait_count = trait_count;
		
		if (tinfo !=null)
			this.tinfo = tinfo;	
	}
	
	private ScriptInfo(AbcFile abc){
		super();
		this.abc = abc;
		abc.ENscript_info.add(this);
		id= abc.ENscript_info.size()-1;
	}
	
	public static void script_info(ByteBuffer bbuf, int position, CpoolInfo cpool, AbcFile abc){
		try{
		bbuf.position(position);

		script_count = unsigned30int(bbuf);
		
		for (int i=0; i< script_count; i++){

			ScriptInfo script_info = new ScriptInfo(abc);
			
			script_info.start = bbuf.position();
			
			script_info.init = unsigned30int(bbuf);
			
			script_info.trait_count = unsigned30int(bbuf);
			
			for (int i2 =0;i2 < script_info.trait_count; i2++)
				script_info.tinfo.add(new TraitInfo(abc,bbuf));
			
			
			abc.methodsNames.put(script_info.init,"script"+i +"$init");
			
			
			script_info.end = bbuf.position()-1;
			//script_info.test();
		}

		} catch (Exception e) {e.printStackTrace();}
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for (byte b: getUI32(init))
				result.add(b);
		
			for (byte b: getUI32(trait_count))
				result.add(b);

			for (int i=0;i<tinfo.size();i++){
				for (byte b: tinfo.get(i).toByteCode())
					result.add(b);
			}
		
		return result;
	}
	

	//getters

	public int getStart() {
		return start;
	}

	public int getEnd() {
		return end;
	}

	public int getInit() {
		return init;
	}

	public ArrayList<TraitInfo> getTinfo() {
		return tinfo;
	}

	public int getTrait_count() {
		return trait_count;
	}
	
	//setters
	
	public void removeScript_info(int id){
		abc.ENscript_info.remove(id);
		script_count--;
	}
	
	public void setInit(int init) {
		this.init = init;
		out("ok");
	}

	public void addTinfo(TraitInfo tinfo){
		this.tinfo.add(tinfo);
		trait_count++;
		out("ok");
	}
	
	public void removeTinfo(int id){
		this.tinfo.remove(id);
		trait_count--;
		out("ok");
	}
	
	public void changeTinfo(int id, TraitInfo tinfo){
		this.tinfo.set(id, tinfo);;
		out("ok");
	}

	
	//toStrings
	
	public  String String(){
		StringBuffer wynik = new StringBuffer();
		
			wynik.append( ">" + start +"\n" );
			
			wynik.append( "init: "+ getInit()+"\n" );

			wynik.append( "trait_count: "+ getTrait_count()+"\n" );
			
			//wynik+= "traits_info:n" + getTinfo()+"\n";	
			
			wynik.append( "<" + end +"\n" );
		
		return wynik.toString();
	}
	
	public String toString(){
		String wynik ="";
		wynik+="script_info id " + id + " " +start+ " - " + end;
		return wynik;
	}
	public String toString2(){
		String wynik ="";
		wynik+="script_info";
		return wynik;
	}
	
}
